implementation module receiverdevice


//	Clean Object I/O library, version 1.0.1


import	StdInt, StdBool, StdFunc, StdList, StdTuple
import	systemid, devicefunctions, /* RWS deviceaccess, */ iostate, /* PA+++*/ receiverid
from	receiverhandle	import	receiverIdentified, /*receiverApplyMessage,*/ receiverAddASyncMessage
from	StdPSt			import	appPIO, accPIO
// RWS +++
import commondef, osevent
import receiverevent	// PA: added due to change of DeviceFunctions

receiverdeviceFatalError :: String String -> .x
receiverdeviceFatalError rule error
	= FatalError rule "receiverdevice" error

ReceiverFunctions :: DeviceFunctions i o .l .p
ReceiverFunctions
	= {	dShow	= id
	  ,	dHide	= id
	  ,	dEvent	= receiverEvent
	  ,	dDoIO	= receiverIO
	  ,	dOpen	= IOStSetDevice (ReceiverSystemState {rReceivers=[]})
	  ,	dClose	= receiverClose
	  }

receiverClose :: !(IOSt .l .p) -> IOSt .l .p
receiverClose ioState
	# (receivers,ioState)	= IOStGetDevice ReceiverDevice ioState
	  rHs					= (ReceiverSystemStateGetReceiverHandles receivers).rReceivers
	  rIds					= map (\{rHandle={rId}}->rId) rHs
	# ioState				= unbindRIds rIds ioState
	# ioState				= IOStRemoveDevice ReceiverDevice ioState
	= ioState


/*	The receiver handles three cases of message events (for the time being timers are not included in receivers):
	- QASyncMessage:
		this is a request to add the given asynchronous message to the indicated 
		receiver. Globally the size of the asynchronous message queue has already been
		increased. 
	- ASyncMessage:
		this is a request to handle the first asynchronous message available in the
		asynchronous message queue. Globally the size of the asynchronous message queue
		has already been decreased.
	- SyncMessage:
		this is a request to handle the given synchronous message.
*/
receiverIO :: OSSleepTime !(DeviceEvent i o) !(PSt .l .p) -> (OSSleepTime,!DeviceEvent i o,!PSt .l .p)
receiverIO sleepTime deviceEvent=:(ReceiverEvent (QASyncMessage event)) pState
	= (sleepTime,deviceEvent,receiverASyncIO event pState)
where
	receiverASyncIO :: !(QASyncMessage i) !(PSt .l .p) -> PSt .l .p
	receiverASyncIO event=:{qasmRecLoc={rlReceiverId},qasmMsg} pState
		#	(receivers,ioState)	= IOStGetDevice ReceiverDevice pState.io
			rsHs				= (ReceiverSystemStateGetReceiverHandles receivers).rReceivers
		#!	rsHs				= qMessage rlReceiverId qasmMsg rsHs
		#	ioState				= IOStSetDevice (ReceiverSystemState {rReceivers=rsHs}) ioState
		#	pState				= {pState & io=ioState}
		=	pState
	where
		qMessage :: !Id msg ![ReceiverStateHandle .ps] -> [ReceiverStateHandle .ps]
		qMessage rid msg [rsH=:{rHandle=rH}:rsHs]
			|	receiverIdentified rid rH
			#!	rH		= receiverAddASyncMessage rid msg rH
			=	[{rsH & rHandle=rH}:rsHs]
			|	otherwise
			#	rsHs	= qMessage rid msg rsHs
			=	[rsH:rsHs]
		qMessage _ _ rsHs
			=	rsHs
receiverIO sleepTime deviceEvent=:(ReceiverEvent (ASyncMessage event)) pState
	# (receivers,pState)= accPIO (IOStGetDevice ReceiverDevice) pState
	  rHs				= ReceiverSystemStateGetReceiverHandles receivers
	# pState			= letOneReceiverDoIO rl rHs pState
	= (sleepTime,deviceEvent,pState)
where
	rl	= event.asmRecLoc
	
	letOneReceiverDoIO :: !RecLoc !(ReceiverHandles (PSt .l .p)) !(PSt .l .p) -> PSt .l .p
	letOneReceiverDoIO {rlParentId} {rReceivers=rsHs} pState
		= pState2
	where
		dummy			= receiverdeviceFatalError "receiverIO _ (ReceiverEvent (ASyncMessage _))" "receiver could not be found"
		(_,rsH1,rsHs1)	= URemove (identifyReceiverStateHandle rlParentId) dummy rsHs
		pState1			= appPIO (IOStSetDevice receivers) pState
		(rsH2,pState2)	= letReceiverDoIO rsH1 pState1
		receivers		= ReceiverSystemState {rReceivers=rsHs1++[rsH2]}
		
		letReceiverDoIO :: !(ReceiverStateHandle .ps) .ps -> (!ReceiverStateHandle .ps,.ps)
		letReceiverDoIO rsH=:{rState=ls,rHandle=rH=:{rASMQ=[msg:tailQ],rFun}} pState
			# (ls,_,pState)	= rFun msg (ls,pState)
			= ({rState=ls,rHandle={rH & rASMQ=tailQ}},pState)
		letReceiverDoIO _ _
			= receiverdeviceFatalError "letReceiverDoIO" "message queue of target receiver is empty"
receiverIO sleepTime (ReceiverEvent (SyncMessage event)) pState
	# (lastProcess,pState)	= accPIO IOStLastInteraction pState
	# (event,pState)		= receiverSyncIO lastProcess event pState
	= (sleepTime,ReceiverEvent (SyncMessage event),pState)
where
	receiverSyncIO :: !Bool !(SyncMessage i o) !(PSt .l .p) -> (!SyncMessage i o,!PSt .l .p)
	receiverSyncIO lastProcess event pState
		| not found
		= (event1,pState2)
		with
			event1	= if lastProcess {event & smError=[ReceiverUnknown]} event
		| isEmpty error
		= ({event & smResp=resp},  pState2)
		= ({event & smError=error},pState2)
	where
		(receivers,ioState)	= IOStGetDevice ReceiverDevice pState.io
		rHs					= (ReceiverSystemStateGetReceiverHandles receivers).rReceivers
		pState1				= {pState & io=IOStSetDevice (ReceiverSystemState {rReceivers=rHs1}) ioState}
		(found,error,resp,rHs1,pState2)
							= applyReceiverFunction event rHs pState1
		
		applyReceiverFunction :: !(SyncMessage i o) ![ReceiverStateHandle .ps] .ps
						-> (!Bool,[MessageError],[o],[ReceiverStateHandle .ps],.ps)
		applyReceiverFunction event=:{smRecLoc={rlReceiverId}} [rsH=:{rState=ls,rHandle=rH}:rsHs] ps
			| not (receiverIdentified rlReceiverId rH)
			= (found,error,resp,[rsH:rsHs1],ps1)
			with
				(found,error,resp,rsHs1,ps1) = applyReceiverFunction event rsHs ps
			| enabled rH.rSelect
			= (True,[],resp,[{rState=ls1,rHandle=rH1}:rsHs],ps1)
			with
				(resp,rH1,(ls1,ps1))	= receiverHandleSyncMessage event rH (ls,ps)
			= (True,[ReceiverUnable],[],[rsH:rsHs],ps)
		applyReceiverFunction _ rsHs ps
			= (False,[],[],rsHs,ps)
receiverIO _ _ _
	= receiverdeviceFatalError "receiverIO" "device event passed receiver event filter without handling"

/*	PA---: this was the previous version of the receiver I/O function.
receiverIO eventDone sleepTime event`=:(MessageEvent event=:{mSync,mParentId,mParentDevice}) pState
	| eventDone || mParentDevice<>ReceiverDevice
	= (eventDone,sleepTime,event`,pState)
	# (lastProcess,ioState)	= IOStLastInteraction pState.io
	  (ioid,ioState)		= IOStGetIOId ioState
	| not (eqSystemId ioid mParentId)
	= (eventDone,sleepTime,event``,{pState & io=ioState})
	with
		event``				= if lastProcess unknownevent` event`
		unknownevent`		= MessageEvent {event & mError=[ProcessUnknown]}
	# pState				= {pState & io=ioState}
	| mSync
	= (True,sleepTime,MessageEvent event1,pState1)
	with
	  (event1,pState1)		= receiverSyncIO lastProcess event pState
	= (True,sleepTime,MessageEvent event1,pState1)
	with
	  (event1,pState1)		= receiverASyncIO event pState
where
	receiverSyncIO :: !Bool !(MessageEvent i o) !(PSt .l .p) -> (!MessageEvent i o,!PSt .l .p)
	receiverSyncIO lastProcess event=:{mParentId,mParentDevice} pState
		| not found
		= (event1,pState2)
		with
			event1	= if lastProcess {event & mError=[ReceiverUnknown]} event
		| isJust opt_error
		= ({event & mError=[fromJust opt_error]},pState2)
		= ({event & mResp=resp},pState2)
	where
		(receivers,	ioState)	= IOStGetDevice ReceiverDevice pState.io
		rHs						= (ReceiverSystemStateGetReceiverHandles receivers).rReceivers
		pState1					= {pState & io=IOStSetDevice (ReceiverSystemState {rReceivers=rHs1}) ioState}
		(found,opt_error,resp,rHs1,pState2)
								= applyReceiverFunction event rHs pState1
		
		applyReceiverFunction :: !(MessageEvent i o) ![ReceiverStateHandle .ps] .ps
					-> (!Bool, Maybe MessageError,[o],[ReceiverStateHandle .ps],.ps)
		applyReceiverFunction event=:{mRId} [rsH=:{rState=ls,rHandle=rH}:rsHs] ps
			| not (receiverIdentified mRId rH)
			= (found,error,resp,[rsH:rsHs1],ps1)
			with
				(found,error,resp,rsHs1,ps1) = applyReceiverFunction event rsHs ps
			| rH.rSelect
			= (True,Nothing,resp,[{rState=ls1,rHandle=rH1}:rsHs],ps1)
			with
				(resp,rH1,(ls1,ps1))	= receiverApplyMessage event rH (ls,ps)
			= (True,Just ReceiverUnable,[],[rsH:rsHs],ps)
		applyReceiverFunction _ rsHs ps
			= (False,Nothing,[],rsHs,ps)
	
	receiverASyncIO :: !(MessageEvent i o) !(PSt .l .p) -> (!MessageEvent i o,!PSt .l .p)
	receiverASyncIO event=:{mRId,mMsg} pState
		# (receivers,ioState)	= IOStGetDevice ReceiverDevice pState.io
		  rsHs					= (ReceiverSystemStateGetReceiverHandles receivers).rReceivers
		  (found,rsHs)			= addMessage mRId mMsg rsHs
		  ioState				= IOStSetDevice (ReceiverSystemState {rReceivers=rsHs}) ioState
		  pState				= {pState & io=ioState}
		| not found
		= ({event & mError=[ReceiverUnknown]},pState)
		= (event,pState)
	where
		addMessage :: !Id mess ![ReceiverStateHandle .ps] -> (!Bool,![ReceiverStateHandle .ps])
		addMessage rid mess [rsH=:{rHandle=rH}:rsHs]
			| receiverIdentified rid rH
			= (True, [{rsH & rHandle=receiverAddASyncMessage rid mess rH}:rsHs])
			# (found,rsHs)	= addMessage rid mess rsHs
			= (found,[rsH:rsHs])
		addMessage _ _ rsHs
			= (False,rsHs)
/* RWS ...
receiverIO eventDone sleepTime event`=:(SystemEvent event=:(_,what,_,_,_,_,_)) pState
	| what==UpdateEvent || what==ActivateEvent || what==OsEvent || what==MouseDownEvent
*/
receiverIO eventDone sleepTime event`=:(SystemEvent event) pState
	| OSEventIsUrgent event
// ... RWS
	= (eventDone,sleepTime,event`,pState )
	# (quitted,pState)		= accPIO IOStClosed pState
	| quitted
	= (eventDone,sleepTime,event`,pState)
	# (receivers,pState)	= accPIO (IOStGetDevice ReceiverDevice) pState
	  rHs					= ReceiverSystemStateGetReceiverHandles receivers
	  pState				= letOneReceiverDoIO rHs pState
	= (eventDone,sleepTime,event`,pState)
receiverIO eventDone sleepTime event` pState
	= (eventDone,sleepTime,event`,pState)
*/

/*	Note:	as with timers, only one Able receiver with a message will be evaluated.
			To ensure fairness of message receipt, such a granted receiver is placed behind
			the other receivers (as usual giving a round-robin order).
*/
/*	PA---
letOneReceiverDoIO :: !(ReceiverHandles (PSt .l .p)) !(PSt .l .p) -> PSt .l .p
letOneReceiverDoIO {rReceivers=rsHs} pState
	# (opt_rsH,rsHs)	= selectReceiver rsHs
	| isNothing opt_rsH
	= pState
	= pState2
	with
		pState1			= appPIO (IOStSetDevice receivers) pState
		(rsH1,pState2)	= letReceiverDoIO (fromJust opt_rsH) pState1
		receivers		= ReceiverSystemState {rReceivers=rsHs++[rsH1]}
where
	selectReceiver :: ![ReceiverStateHandle .ps] -> (!Maybe (ReceiverStateHandle .ps),![ReceiverStateHandle .ps])
	selectReceiver [rsH=:{rHandle=rH=:{rMessQ,rSelect}}:rsHs]
		| isEmpty rMessQ || not rSelect
		= (rsH1,[rsH:rsHs1])
		with
			(rsH1,rsHs1)	= selectReceiver rsHs
		# (Msg msg d,tailQ)	= HdTl rMessQ
		| d>0
		= (rsH1,[rsH`:rsHs1])
		with
			(rsH1,rsHs1)	= selectReceiver rsHs
			rsH`			= {rsH & rHandle={rH & rMessQ=[Msg msg (d-1):tailQ]}}
		= (Just rsH,rsHs)
	selectReceiver rsHs
		= (Nothing,rsHs)
	
	letReceiverDoIO :: !(ReceiverStateHandle .ps) .ps -> (!ReceiverStateHandle .ps,.ps)
	letReceiverDoIO rsH=:{rState,rHandle=rH=:{rMessQ=[Msg msg d:tailQ],rFun}} pState
		# (state,_,pState)	= rFun msg (rState,pState)
		= ({rState=state,rHandle={rH & rMessQ=tailQ}},pState)
	letReceiverDoIO _ _
		= receiverdeviceFatalError "letReceiverDoIO" "function should be applied to non-empty message queue"
*/

identifyReceiverStateHandle :: !Id !(ReceiverStateHandle .ps) -> (!Bool,!ReceiverStateHandle .ps)
identifyReceiverStateHandle id rsH=:{rHandle={rId}}
	= (id==rId,rsH)

ReceiverSystemStateGetReceiverHandles :: !(DeviceSystemState .ps) -> ReceiverHandles .ps
ReceiverSystemStateGetReceiverHandles (ReceiverSystemState rsHs)
	= rsHs
ReceiverSystemStateGetReceiverHandles _
	= receiverdeviceFatalError "ReceiverSystemStateGetReceiverHandles" "argument is no ReceiverSystemState"
